/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.forward.ForwardingFilter;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipForwardHandler
extends AbstractConnectionServiceRequestHandler {
    public static final String REQUEST = "tcpip-forward";
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add((int)8);
    public static final TcpipForwardHandler INSTANCE = new TcpipForwardHandler();

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (!REQUEST.equals(request)) {
            return super.process(connectionService, request, wantReply, buffer);
        }
        String address = buffer.getString();
        int port = buffer.getInt();
        SshdSocketAddress socketAddress = new SshdSocketAddress(address, port);
        ForwardingFilter forwarder = Objects.requireNonNull(connectionService.getForwardingFilter(), "No TCP/IP forwarder");
        SshdSocketAddress bound = forwarder.localPortForwardingRequested(socketAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[{}][want-reply-{}] {} => {}", new Object[]{connectionService, request, wantReply, socketAddress, bound});
        }
        if (bound == null) {
            return RequestHandler.Result.ReplyFailure;
        }
        port = bound.getPort();
        if (wantReply) {
            Session session = connectionService.getSession();
            buffer = session.createBuffer((byte)81, 4);
            buffer.putInt((long)port);
            session.writePacket(buffer);
        }
        return RequestHandler.Result.Replied;
    }
}

