/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyPairIdentity
implements PublicKeyIdentity {
    private final KeyPair pair;
    private final Collection<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)primary, (SignatureFactoriesManager)secondary), (String)"No available signature factories", (Object[])new Object[0]);
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    public PublicKey getPublicKey() {
        return this.pair.getPublic();
    }

    public byte[] sign(byte[] data) throws Exception {
        String keyType = KeyUtils.getKeyType((Key)this.getPublicKey());
        Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create(this.signatureFactories, (String)keyType), (String)"No signer could be located for key type=%s", (Object)keyType);
        verifier.initSigner(this.pair.getPrivate());
        verifier.update(data);
        return verifier.sign();
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType((Key)pubKey) + ", factories=" + NamedResource.getNames(this.signatureFactories) + ", fingerprint=" + KeyUtils.getFingerPrint((PublicKey)pubKey);
    }
}

