/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManager.class);
    private Map<String, GreenMailUser> loginToUser = Collections.synchronizedMap(new HashMap());
    private Map<String, GreenMailUser> emailToUser = Collections.synchronizedMap(new HashMap());
    private ImapHostManager imapHostManager;
    private boolean authRequired = true;

    public UserManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public GreenMailUser getUser(String login) {
        return this.loginToUser.get(UserManager.normalizerUserName(login));
    }

    public GreenMailUser getUserByEmail(String email) {
        return this.emailToUser.get(UserManager.normalizerUserName(email));
    }

    public GreenMailUser createUser(String email, String login, String password) throws UserException {
        UserImpl user = new UserImpl(email, login, password, this.imapHostManager);
        user.create();
        this.addUser(user);
        return user;
    }

    public void addUser(GreenMailUser user) {
        this.deleteUser(user);
        this.loginToUser.put(UserManager.normalizerUserName(user.getLogin()), user);
        this.emailToUser.put(UserManager.normalizerUserName(user.getEmail()), user);
    }

    public void deleteUser(GreenMailUser user) {
        GreenMailUser deletedUser = this.loginToUser.remove(UserManager.normalizerUserName(user.getLogin()));
        if (deletedUser != null) {
            this.emailToUser.remove(UserManager.normalizerUserName(deletedUser.getEmail()));
            deletedUser.delete();
        }
    }

    public Collection<GreenMailUser> listUser() {
        return Collections.unmodifiableCollection(this.loginToUser.values());
    }

    public boolean test(String userId, String password) {
        if (log.isDebugEnabled()) {
            log.debug("Authenticating user " + userId);
        }
        GreenMailUser u = this.getUser(userId);
        if (!this.authRequired) {
            if (null == u) {
                try {
                    this.createUser(userId, userId, password);
                }
                catch (UserException e) {
                    throw new IllegalStateException("Failed to create user with userid=" + userId, e);
                }
            }
            return true;
        }
        return null != u && this.checkPassword(u.getPassword(), password);
    }

    private boolean checkPassword(String expectedPassword, String password) {
        return null != expectedPassword && expectedPassword.equals(password) || null == password && expectedPassword == null;
    }

    public void setAuthRequired(boolean auth) {
        this.authRequired = auth;
    }

    public ImapHostManager getImapHostManager() {
        return this.imapHostManager;
    }

    private static String normalizerUserName(String login) {
        return login.trim().toLowerCase(Locale.ENGLISH);
    }

    public boolean hasUser(String userId) {
        String normalized = UserManager.normalizerUserName(userId);
        return this.loginToUser.containsKey(normalized) || this.emailToUser.containsKey(normalized);
    }
}

